function formatBytes(a,b=2)
    {if(a===0 || a<=0) 
        return"0.00&nbsp;B";
     const c=0>b?0:b,d=Math.floor(Math.log(a)/Math.log(1024));
     num=(a/Math.pow(1024,d)).toFixed(2);
     
     numString=num+"&nbsp;"+["B","kB","MB","GB","TB","PB","EB","ZB","YB"][d]
     return numString;
     
     }



function padInt(num, size) 
{
    var s = parseInt(num)+"";
    while (s.length < size) s = "0" + s;
    return s;
}

//format date to human readable format
//20200704_193224 to 19:32:24 4.7.2020
function formatDate(dateString, useRelative=false)
{
    buffer="";
    if (dateString==-1)
        return "Never";
            
    y=parseFloat(dateString.substring(0,4));
    m=parseFloat(dateString.substring(4,6));
    d=parseFloat(dateString.substring(6,8));
    H=dateString.substring(9,11);   //keep leading zeroes
    M=dateString.substring(11,13);
    s=dateString.substring(13,15);

    if (useRelative)
    {
        now = new Date(); // Current date now.
        dateLast= new Date(y, m-1, d, H, M, s, 0);

        diffSeconds=parseInt((now-dateLast)/1000);
        buffer+="before ";
        //days
        if ((diffSeconds/24/3600)>1)
        {
            buffer+=parseInt(diffSeconds/24/3600)+" days";
            diffSeconds=diffSeconds % (24/3600); 
        }
        //hours
        if (diffSeconds/3600>1)
        {
            buffer+= padInt(diffSeconds/3600,2)+":";
            diffSeconds=diffSeconds % (3600); 
        }
        else
        {
            buffer+="00:";
        }
        if (diffSeconds/60 >1)
        {
            buffer+= padInt(diffSeconds/60,2)+":";
            diffSeconds=diffSeconds % (60); 
        }
        buffer+= padInt(diffSeconds,2);
        
        return buffer;
    }
    else
    {
        buffer+=H+":"+M+":"+s+" "+d+"."+m+"."+y;
    }
    
    return buffer;
    //(H+":"+M+":"+s+" "+d+"."+m+"."+ y);
}

var updateAllStatusInterval;
//myVar=ClearInterval();
function autoRefresh()
{   //setInterval(autoRefresh, 1000);
    updateAllStatusInterval=window.setInterval(updateDevicesStatus, 1000);
}




function checkAll(checkboxItem, deviceFamily)
{   //look for all inputs which starts with value that is in the controlString...
    //the value (check/uncheck) is retrieved from function parameter 'checkboxItem'
	var controlString = "enable_".concat(deviceFamily);
    var enableElements = [];
    var inputs = document.getElementsByTagName("input");
    for(var i = 0; i < inputs.length; i++) 
        {
        if(inputs[i].id.indexOf(controlString) == 0)
            {
            enableElements.push(inputs[i]);
            }
        }
    
    for (var i=0; i<enableElements.length; i++)
    {
        enableElements[i].checked=checkboxItem.checked;
    }    
}

function asynchronousHTTP(apiUrl)
{
	var dataShutDown = apiUrl.getAttribute("data");
	var xmlhttp = new XMLHttpRequest();
	
	xmlhttp.open("GET", dataShutDown, true);
	xmlhttp.send();

	if (dataShutDown.search("shutdown") != -1) {
		alert("Tracebox has been shut down.");
	} else if (dataShutDown.search("reboot") != -1) {
		alert("Tracebox has been rebooted.");
	}
}