<?php


$apiUrl="http://{$_SERVER['SERVER_ADDR']}:8080/";
$apiMethod="GET";
$message="";
$errors="";
$useRelativeDate=(getSubmitted('useRelativeDate')=="on"?true:false);
$debug = "default";
$canFormatType=callApi("get_format/can");
$serialFormatType=callApi("get_format/serial");
$httpFormatType=callApi("get_format/http");


function formatDate($dateString, $useRelative=false )   
{
    if ($dateString==-1)
        return "Never";
    $datetime= DateTime::createFromFormat('Ymd_His', $dateString);
    
    if ($useRelative):
        $now=new DateTime("NOW");
        $diffSeconds=$now->getTimestamp()-$datetime->getTimestamp();
        //print($diffSeconds);
        $buffer="before ";
        
        //days
        if (($diffSeconds/24/3600)>1):
            $buffer.="".(int)($diffSeconds/24/3600)." days";
            $diffSeconds=$diffSeconds % (24/3600); 
        endif;
        //hours
        if ($diffSeconds/3600>1):
            $buffer.= sprintf("%2d:", $diffSeconds/3600);
            $diffSeconds=$diffSeconds % (3600); 
        else:
            $buffer.="00:";
        endif;
        if ($diffSeconds/60 >1):
            $buffer.= sprintf("%02d:", $diffSeconds/60);
            $diffSeconds=$diffSeconds % (60); 
        endif;
        $buffer.= sprintf("%02d", $diffSeconds);
        
        return $buffer;
            
        
    else:
        return $datetime->format("H:i:s j.n.Y");
    endif;
    
    
}

function getSubmitted($varName)
{
    if(isset($_POST[$varName])):
        return $_POST[$varName];
    else:
        return NULL;
    endif;    
}

class JSONObject 
{
    public function __construct($json = false) 
    {
        if ($json) $this->set(json_decode($json, true));
    }

    public function set($data) 
    {
        foreach ((array)$data AS $key => $value) 
        {
            if (is_array($value)) 
            {
                $sub = new JSONObject;
                $sub->set($value);
                $value = $sub;
            }
            $this->{$key} = $value;
        }
    }
}

function formatBytes($bytes, $decimals = 2)
{
    $factor = floor((strlen($bytes) - 1) / 3);
    if ($factor > 0) $sz = 'kMGT';
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) ."&nbsp;". @$sz[$factor - 1] . 'B';
}

function addError($msg)
{
    global $errors;   
    $errors=$errors."<div>$msg</div>";
}

function callApi($suburl, $data = false)
{
    global $apiMethod;
    global $apiUrl;
    $url=$apiUrl.$suburl;
    //print("<br>call api: $url");
    $curl = curl_init();
    
    switch ($apiMethod)
    {
        case "POST":http://10.216.200.71:8080/http/dev0/start
            curl_setopt($curl, CURLOPT_POST, 1);
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_PUT, 1);
            break;
        default:
            if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
    }

    // Optional Authentication:
    // curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    // curl_setopt($curl, CURLOPT_USERPWD, "username:password");

    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $content = curl_exec($curl);
    //var_dump("<br>".$content);    
    
    if ($content==false) { 
		addError("API offline ($suburl)"); 
		//echo '<script>alert("API offline (\"' . $suburl. '\")");</script>'; 
	}
    
    curl_close($curl);
    
    
    return $content;
}

function getStatus($devicePath)
{
	$content=callApi($devicePath."/status");
    $status=new JSONObject($content);
    //print_r($status);
	return $status;
}

function getInfo($devicePath)
{
	$jsonString=callApi($devicePath."/info");
	$info=new JSONObject($jsonString);
	return $info;
}

//return formated html for ethernet (configuration column)
function getConfig_ethernet($info)
{
    return "-";
}
//return formated html for CAN (configuration column)
function getConfig_can($info)
{
	$ifacePath=$info->type."/".$info->interface;
    $ifaceId=$info->type."".$info->interface;
	$canInfo=callApi($ifacePath."/info");
    $canInfo=new JSONObject($canInfo);
	
	if ($canInfo->speed == 2000000) {
		$selected1 = "";
		$selected2 = "";
		$selected3 = "selected";
	} elseif ($canInfo->speed == 1000000) {
		$selected1 = "";
		$selected2 = "selected";
		$selected3 = "";
	} else {
		$selected1 = "selected";
		$selected2 = "";
		$selected3 = "";	
	}
    $buffer="<select name=\"s[$ifacePath]\" id=\"select_speed\">
		<option value=\"500000\" $selected1>500 kBit/s</option>
        <option value=\"1000000\" $selected2>1000 kBit/s</option>
        <option value=\"2000000\" $selected3>2000 kBit/s</option>
    </select>"; 


    return $buffer;
}
//return formated html for SERIAL (configuration column)
function getConfig_serial($info)
{
    $ifacePath=$info->type."/".$info->interface;
    $ifaceId=$info->type."".$info->interface;
	
    $buffer="<input class=\"serialSpeed\" id=\"speed_$ifaceId\" name=\"a[$ifacePath/set_speed]\" value=\"".$info->speed."\" type=\"number\" min=\"1\" max=\"2000000\">8N1&nbsp;none</td>"; 
    return $buffer;
}

//return formated html for HTTP (configuration column)
function  getConfig_http($info)
{
    $ifacePath="$info->type/$info->interface";
    $ifaceId=$info->type."".$info->interface;
    $buffer="<nobr>
				<input class='ip'       name='a[$ifacePath/set_address]'      id='address_$ifaceId' type='edit' value='".$info->ip_address."'>
				<input class='ip_port'  name='a[$ifacePath/set_port]'   id='port_$ifaceId' type='number' max='65535' min='1' value='".$info->port."'>
			</nobr>";
    return $buffer;
}

function createTriggerRows()
{
    global $useRelativeDate;
    $buffer="";
    $devicesContent=callApi("trigger/device_list");
    $devices=new JSONObject($devicesContent);
    
    foreach ($devices as $key=>$ifaceName):
        $ifacePath="trigger/$ifaceName";
        $ifaceId="trigger_$ifaceName";
        
        $info   =getInfo($ifacePath,);
        $status =getStatus($ifacePath);
        
		$buffer.="
			<tr><!-- node name: $ifacePath -->
				<td>
					<input id='enable_$ifaceId' name=\"e[$ifacePath]\" type=\"checkbox\" value=\"enable\"".($info->enabled==1?"checked":"").">
				</td>
				<td >".$info->interface."</td>
				<td ><input type=\"edit\" name=\"a[$ifacePath/set_name]\" value=\"".$info->device_name."\" class=\"deviceName\"></td>
				<td id='action_$ifaceId'><button name=\"a[$ifacePath]\" type=\"submit\" value=\"".strtolower("Trigger")."\">Trigger</button></td>";

    endforeach;
    
    return $buffer;
}
function createRows($deviceFamily)
{
    global $useRelativeDate;
    $buffer="";
    $devicesContent=callApi("$deviceFamily/device_list");
    $devices=new JSONObject($devicesContent);

    foreach ($devices as $key=>$ifaceName):
        $ifacePath="$deviceFamily/$ifaceName";
        $ifaceId="${deviceFamily}_$ifaceName";
        
        $info   =getInfo($ifacePath,);
        $status =getStatus($ifacePath);
        
        $isRunning=($status->status=="ACTIVE");
        $isRunning?$runningClass="running":$runningClass="idle";
        $isRunning?$actionButton="Stop":$actionButton="Start";

        //print("<br>$ifaceId");
        
        $buffer.="
            <tr><!-- node name: $ifacePath -->
                <td>
                    <input id='enable_$ifaceId' name=\"e[$ifacePath]\" type=\"checkbox\" value=\"enable\"".($info->enabled==1?"checked":"").">
                </td>
                <td id=\"status_$ifaceId\" class='$runningClass'>".($isRunning?"Running":"Idle")."</td>
                <td >".$info->interface."</td>						
                <td ><input type=\"edit\" name=\"a[$ifacePath/set_name]\" value=\"".$info->device_name."\" class=\"deviceName\"></td>
                <td>";
        
        $func="getConfig_$deviceFamily";    //call adequate function for each deviceFamily
        $buffer.=$func($info);
        
        $buffer.="</td>
                <td id='action_$ifaceId'><button name=\"a[$ifacePath]\" type=\"submit\" value=\"".strtolower($actionButton)."\">$actionButton</button></td>";
        if ($status->log_created>0):
            $buffer.="
                <td><a href=\"/trace/$status->log_filename\" title=\"$status->log_filename\" id='log_file_size_$ifaceId' class=\"download\">".formatBytes($status->log_file_size)."</a></td>";
		else:
            $buffer.="
                <td id='log_file_size_$ifaceId'>".formatBytes(0)."</td>";
        endif;
		$buffer.="		
                <td id='log_created_$ifaceId'>".formatDate($status->log_created, false)."</td>
                <td id='log_last_modification_$ifaceId'>".formatDate($status->log_last_modification, $useRelativeDate)."</td>
            </tr>
                ";
    endforeach;
    return $buffer;
}

function getDevices($deviceFamily)
{
        $content=callApi($deviceFamily."/device_list");
        $devicesTmp=new JSONObject($content);
        $devices=array();
       
        foreach ((array)$devicesTmp as $key=>$name):
            //$devices[]=['ethernet/'.$name];
            //print("<br> $name");
            $devices[]=$deviceFamily."/".$name;
        endforeach;
    return $devices;
}

function downloadConfigurationFile($file)
{
		//download file
		header("Content-Description: File Transfer");
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=".$file);
		header("Content-Transfer-Encoding: binary");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		header("Content-Length: " . filesize("/var/tracebox/platform/".$file)); //Absolute URL
		ob_clean();
		flush();
		readfile("/var/tracebox/platform/".$file); //Absolute filename path
		exit();
}

function generateUpdateDevice($deviceFamily)
{
    $content=callApi("$deviceFamily/device_list");
    $buffer="";
    if ($content!=false):
        $devices=new JSONObject($content);
        foreach ((array)$devices as $deviceName):
            $buffer.="\n\t\tupdateStatus('$deviceFamily/$deviceName', '${deviceFamily}_$deviceName')";
        endforeach;

    endif;
    return $buffer;
}

function processSubmit()
{
    global $debug;	
	global $apiUrl;
	global $error;
    global $message;
    global $canFormatType;
    global $serialFormatType;
    global $httpFormatType;
    global $useRelativeDate;
    //print_r($_POST);
	$actions=getSubmitted('a');
    $enable=getSubmitted('e');
    $massAction=getSubmitted('action');
    $formatTypeAction=getSubmitted('type_action');
	$canSpeed=getSubmitted('s');

	
    if (!isset($actions)):
        return;
    endif;

     
    $devicesEth=getDevices("ethernet");
    $devicesCan=getDevices("can");
    $devicesSerial=getDevices("serial");
    $devicesHttp=getDevices("http");
    $devicesTrigger=getDevices("trigger");
    $devices=array_merge($devicesEth, $devicesCan, $devicesSerial, $devicesHttp, $devicesTrigger);
    
    
    
    
    if(isset($formatTypeAction)){
		$jsonString=callApi("set_format/$formatTypeAction");
		$canFormatType=callApi("get_format/can");
		$serialFormatType=callApi("get_format/serial");
		$httpFormatType=callApi("get_format/http");
    }
    
    switch($massAction):
        case "Start_all":
            foreach($devices as $device):
                $actions[$device]="start";
            endforeach;
        break;
        case "Stop_all":
            foreach($devices as $device):
                $actions[$device]="stop";
            endforeach;
        break;
        case "Start_checked":
            foreach($devices as $device):
                if (array_key_exists($device, $enable)):
                    $actions[$device]="start";
                endif;
            endforeach;
        break;
        case "Stop_checked":
            foreach($devices as $device):
                if (array_key_exists($device, $enable)):
                    $actions[$device]="stop";
                endif;
            endforeach;
        break;  
        case "Load_Configuration":
            $configurationName=getSubmitted("configurationName");
            $jsonString=callApi("platform/load/$configurationName");
            $response=new JSONObject($jsonString, true);
			
			
			if (!isset($response->return)):
				echo '<script>alert("Configuration \"' . $configurationName . '\" does not exist!");</script>'; 
			elseif ($response->return==0):
				echo '<script>alert("Configuration \"' . $configurationName. '\" has been loaded.");</script>'; 
			else:
				echo '<script>alert("Configuration \"' . $configurationName. '\" failed to load!");</script>'; 
			endif;
			return;  //dont process any changes from submit
		break;
        case "Save_Configuration":
        //      Save Configuration is called after all actions
        break;
    endswitch;
    
    
    $startStopArray=array(); //start/stop must be called after sets

    //do sets (call all api excluding start/stop) 
    foreach((array)$actions as $ifacePath=>$action):
        //print("<br>$ifacePath=$action");
        if ($action=="start" || $action=="stop"):   
            $startStopArray[$ifacePath]=$action;
        else:
            $content=callApi("$ifacePath/$action");  
            
            //if ($action == "trigger") {
			//	echo '<script>alert("Trigger has been pressed!");</script>'; 
            //}
        endif;
    endforeach;
    
    //do disable action
    foreach((array)$devices as $device):
        if (array_key_exists($device, (array)$enable)):
            callApi("$device/enable");
        else:
            callApi("$device/disable");            
        endif;
    endforeach;
    

    //do start/stop action 
    foreach((array)$startStopArray as $ifacePath=>$action):	
		if (substr($ifacePath,0,3) == "can") {

			$speed = $canSpeed[$ifacePath];
			callApi("$ifacePath/$action"."?speed="."$speed");
		} else {
			callApi("$ifacePath/$action");
		}	
    endforeach;

    
    

    
    usleep(20000); //because of possible delay after start logging because of very intensive load
    			
	$files_to_download=array();
	$count = 0;
	$extension = ".zip";
    switch($massAction):
		

		case "prepare_download/tar.gz":
			$extension = ".tar.gz";
		case "prepare_download/zip":
			
			$jsonString=callApi("platform/".$massAction);
			$response=new JSONObject($jsonString, true);
			$fileTrace = "/var/tracebox".$response->filename;
		
			//download file
			header("Content-Description: File Transfer");
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=".date("Y_md_His")."". $extension );
			header("Content-Transfer-Encoding: binary");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Pragma: public");
			header("Content-Length: " . filesize($fileTrace)); //Absolute URL
			ob_clean();
			flush();
			readfile($fileTrace); //Absolute filename path
			exit();

		break;
        case "Save_configuration":
            $configurationName=getSubmitted("configurationName");
            $jsonString=callApi("platform/save/$configurationName");
            $response=new JSONObject($jsonString, true);
            if ($response->return==0):
                echo '<script>alert("Configuration \"' . $configurationName . '\" has been saved.");</script>'; 
            else:
                echo '<script>alert("Saving of the \"' . $configurationName . '\" configuration has failed!");</script>'; 
            endif;
        break;
        case "Download_configuration":
			
			$configurationName=getSubmitted("configurationName");
            $jsonString=callApi("platform/get/$configurationName");
			$response=new JSONObject($jsonString, true);
			
			
			if (!isset($response->return)):
				echo '<script>alert("Getting configuration \"' . $configurationName . '\" !");</script>'; 
			else:
				echo '<script>alert("Configuration \"' . $configurationName . '\" does not exist!");</script>'; 
			endif;
			
			downloadConfigurationFile($configurationName);
		break;
    endswitch;
    
    
}

function isApiOnline()
{
    global $apiUrl;
    global $apiMethod;
    $content=callApi("ethernet/device_list");
    
    print (($content==""?"<img src=\"img/semaphore_red.svg\" height=\"35px\"> offline": "<img src=\"img/semaphore_green.svg\" height=\"35px\"> online"));
	return $content!=""	;
}

function getConfigurationsDataList()
{
    $content=callApi("platform/list");
    $configs=new JSONObject($content);
    $buffer="";
    foreach ((array)$configs as $configName):
        $buffer.="<option value=\"$configName\">$configName</option>";
    endforeach;
    return $buffer;
}

processSubmit();
?>

<!DOCTYPE html>
<html>
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<script>
			//use "measurement as default location (home page)
			if (!window.location.hash)
			{
				window.location.hash = '#measurement';
			}
			var useRelative=<?php echo $useRelativeDate?"true":"false" ;?>;

			function updateStatus(devicePath, deviceId)
			{
				var xmlhttp = new XMLHttpRequest();
				xmlhttp.onreadystatechange = function()
				{
					if (this.readyState == 4 && this.status == 200)
					{
						var myObj = JSON.parse(this.responseText);
						document.getElementById("log_file_size_"+deviceId).innerHTML=formatBytes(myObj.log_file_size, 2);
						document.getElementById("log_created_"+deviceId).innerHTML=formatDate(myObj.log_created, false);
						document.getElementById("log_last_modification_"+deviceId).innerHTML=formatDate(myObj.log_last_modification, window.useRelative);
					}
				};

				xmlhttp.open("GET", ("<?php echo $apiUrl; ?>"+devicePath+"/status"), true);
				xmlhttp.send();
			}


			function updateDevicesStatus()
			{
				<?php
					print( generateUpdateDevice("ethernet"));
					print( generateUpdateDevice("can"));
					print( generateUpdateDevice("serial"));
					print( generateUpdateDevice("http"));
				?>
			}
		</script>

		<link rel="stylesheet" media="screen" href="main.css">
		<link rel="stylesheet" media="screen" href="menu.css">
		<link rel="stylesheet" media="screen" href="toggle.css">
		<script src='utils.js'></script>

		<style>
			/* display checkbox and label on the same base line*/
			.fleft {
				float:left;
				padding-left:2px;
				padding-right: 5px;
			}

		</style>
	</head>
	<body>
		<nav class="sidenav">
			<a href="#measurement" title="measurement"><img  src="img/measurement.svg" alt="measurement"><div class="title">measurement</div></a>
			<a href="#triggers" ><img  src="img/trigger.svg" alt="triggers"><div class="title">triggers</div></a>
			<a href="#system"><img  src="img/computer.svg" alt="system"><div class="title">system</div></a>
			<a href="#system_info"><img  src="img/system_info.svg" alt="system_info"><div class="title">system info</div></a>
			<a href="#help" ><img  src="img/help.svg" alt="help"><div class="title">help</div></a>
		</nav>
		</div>
		<form method="POST">
			<div class= 'container'> 
				<section id= 'measurement'>
					<h1>Measurement</h1>
					
					<div>
						<!--menu top -->
						<table class="su">
							<tr>
								<td rowspan="2" ><?php isApiOnline(); ?></td>
							<td><button type="submit" name="action" value="Start_all">Start All</button></td>
							<td><button type="submit" name="action" value="Stop_all">Stop All</button></td>
							<!--td><button type="submit" name="action" value="Download_all">Download All</button></td-->
							<td><button type="submit" name="action" class="fleft" value="Download_configuration">Download Configuration</td>								
							<td><button type="submit" name="action" value="Load_Configuration">Load Configuration</button></td>
							<td rowspan="2">
								<label for="configurationInput">
									Configuration Name
								</label>
								<input id="configurationInput" list="configurations" name="configurationName" class="configurationSelect">
								<datalist id="configurations">
									<?php print(getConfigurationsDataList()); ?>
								</datalist>	
							</td>
							</tr>
							<tr>
								<td><button type="submit" name="action" value="Start_checked">Start Checked</button></td>
								<td><button type="submit" name="action" value="Stop_checked">Stop Checked</button></td>
								<!--td><button type="submit" name="action" value="Download_checked">Download Checked</button></td-->
								<td><div class="dropdown2">
									<button>Download Traces</button>
										<div class="dropdown2-content">
											<div><button type="submit" name="action" value="prepare_download/zip">zip</button></div>
											<div><button type="submit" name="action" value="prepare_download/tar.gz">tar.gz</button></div>
										</div>
							</div></td>
							<td><button type="submit" name="action" class="fleft" value="Save_configuration">Save Configuration As </button></td>
								
							</tr>
						</table>
						<td>
									<input class="tgl tgl-light fleft" id="cb1" type="checkbox" name="useRelativeDate" value="on" <?php echo $useRelativeDate==1?"checked":" "; ?> onChange="useRelative=this.checked; "/>
									<label class="tgl-btn fleft" for="cb1"></label>
									&nbsp;
									<label for="cb1">use relative time</label>
						</td>
						<!----------- ---------- ETHERNET ------------------------------------->
						<table class="center dev">
							<tr>
								<td colspan="1" class="header">Ethernet</td>
								<td colspan="7" class="header right">Trace Format:</td>
								<td colspan="1" class="dropdown">
									<button class="dropbtn">pcapng</button>
									<div id="ethernetFormatType" class="dropdown-content">
										<div><button type="submit" class="drpdwn">pcapng</button></div>
									</div>
								</td>
							</tr> 
							<tr class="first_row">
								<th ><input type="checkbox" id="ethernetCheckAll" name="ethernetCheckAll" onClick="checkAll(this,'ethernet')" <?php print(isset($_POST['ethernetCheckAll'])?"checked":""); ?> ></th>
								<th>Status</th>
								<th>Interface</th>
								<th>Device name</th>
								<th>Speed</th>
								<th class="center">Action</th>
								<th class="center">Logsize</th>
								<th>Created</th>
								<th class="center">Last modification</th>
							</tr>
							</tr> 
							
							<?php 
								print (createRows("ethernet"));
							?>
						</table>
						
						<!----------- ---------- CAN ------------------------------------->
						<table class="center dev">
							<tr>
								<td colspan="1" class="header">CAN</td>
								<!--td colspan="6" class="header"><?php echo $debug; ?></td-->
								<td colspan="7" class="header right">Trace Format:</td>
								<td colspan="1" class="dropdown">
									<button class="dropbtn"><?php echo $canFormatType; ?></button>
									<div id="httpFormatType" class="dropdown-content">
										<div><button type="submit" class="drpdwn" name="type_action" value="can/asc">asc</button></div>
										<div><button type="submit" class="drpdwn" name="type_action" value="can/pcapng">pcapng</button></div>
									</div>
								</td>
							</tr> 
							<tr class="first_row">
								<th ><input type="checkbox" id="canCheckAll" name="canCheckAll" onClick="checkAll(this,'can')" <?php print(isset($_POST['canCheckAll'])?"checked":""); ?> ></th>
								<th>Status</th>
								<th>Interface</th>
								<th>Device name</th>
								<th>Speed</th>
								<th class="center">Action</th>
								<th class="center">Logsize</th>
								<th>Created</th>
								<th class="center">Last modification</th>
							</tr>
							</tr>
							
							<?php 
								print (createRows("can"));
							?>
						</table>
						
						<!----------- ---------- SERIAL ------------------------------------->
						<table class="center dev">
							<tr>
								<td colspan="1" class="header">Serial</td>
								<td colspan="7" class="header right">Trace Format:</td>
								<td colspan="1" class="dropdown">
									<button class="dropbtn"><?php echo $serialFormatType; ?></button>
									<div id="httpFormatType" class="dropdown-content">
										<div><button type="submit" class="drpdwn" name="type_action" value="serial/log">log</button></div>
										<div><button type="submit" class="drpdwn" name="type_action" value="serial/pcapng">pcapng</button></div>
									</div>
								</td>
							</tr> 
							<tr class="first_row">
								<th><input type="checkbox" id="serialCheckAll" name="serialCheckAll" onClick="checkAll(this,'serial')" <?php print(isset($_POST['serialCheckAll'])?"checked":""); ?> ></th>
								<th>Status</th>
								<th>Interface</th>
								<th>Device name</th>
								<th>Speed</th>
								<th class="center">Action</th>
								<th class="center">Logsize</th>
								<th>Created</th>
								<th class="center">Last modification</th>
							</tr>
							</tr> 
							
							<?php 
								print (createRows("serial"));
							?>
						</table>
						
						<!----------- ---------- HTTP ------------------------------------->
						<table class="center dev">
							<tr>
								<td colspan="1" class="header">HTTP</td>
								<td colspan="7" class="header right">Trace Format:</td>
								<td colspan="1" class="dropdown">
									<button class="dropbtn"><?php echo $httpFormatType; ?></button>
									<div id="httpFormatType" class="dropdown-content">
										<div><button type="submit" class="drpdwn" name="type_action" value="http/raw">raw</button></div>
										<div><button type="submit" class="drpdwn" name="type_action" value="http/pcapng">pcapng</button></div>
									</div>
								</td>
							</tr> 
							<tr class="first_row">
								<th><input type="checkbox" id="httpCheckAll" name="httpCheckAll" onClick="checkAll(this,'http')" <?php print(isset($_POST['httpCheckAll'])?"checked":""); ?> ></th>
								<th>Status</th>
								<th>Interface</th>
								<th>Device name</th>
								<th>Remote IP + Port</th>
								<th class="center">Action</th>
								<th class="center">Logsize</th>
								<th>Created</th>
								<th class="center">Last modification</th>
							</tr>
							</tr> 
							
							<?php 
								print (createRows("http"));
							?>
						</table>
					</div>
				</section>
				
				<section id= 'system'>
					<h1>System</h1>
					<div>
						<ul style="width: 200px; list-style:none;"> 
							<li><button id="restartButton" data="<?php echo $apiUrl."reboot";?>" type="button" onclick="asynchronousHTTP(this)">Restart</button>
							<li><button id="shutDownButton" data="<?php echo $apiUrl."shutdown";?>" type="button" onclick="asynchronousHTTP(this)">Shutdown</button>
							<li><button onclick="location.href='/update/'" type="button">Update</button>
						</ul>
					</div>
				</section>
				
				<section id= 'triggers'>
					<h1>Triggers</h1>
					<div>
						<table class="dev left">
							
							<tr>
								<td colspan="9" class="header">Triggers</td>
							</tr> 
							<tr class="first_row">
								<th ><input type="checkbox" id="triggerCheckAll" name="triggerCheckAll" onClick="checkAll(this,'trigger')" <?php print(isset($_POST['triggerCheckAll'])?"checked":""); ?> ></th>
								<th>Interface</th>
								<th>Device name</th>
								<th class="center">Action</th>
							</tr>
							</tr> 
							
							<?php 
								print (createTriggerRows());
							?>
						</table>
					</div>
				</section>
				
				<section id= 'system_info'>
					<h1>System Info</h1>
					<div>
						<!--------- modules info -------------------->
						<table class="dev left">
							<tr>
								<td class="header" colspan="2">Modules</td>
							</tr>
							<tr class="first_row">
								<th>Name</th>
								<th>Version</th>
							</tr>
							<tr>
								<td>Can-Utils</td><td><?php echo shell_exec("dpkg-query -f='\${Version}' -W can-utils"); ?></td>
							</tr>
							<tr>
								<td>Ascdump</td><td><?php echo shell_exec("dpkg-query -f='\${Version}' -W ascdump"); ?></td>
							</tr>
							<tr>
								<td>Serial2udp</td><td><?php echo shell_exec("dpkg-query -f='\${Version}' -W serial2udp"); ?></td>
							</tr>
							<tr>
								<td>Daemon</td><td><?php echo shell_exec("dpkg-query -f='\${Version}' -W tracebox-daemon"); ?></td>
							</tr>
							<tr>
								<td>Web Interface</td><td><?php echo shell_exec("dpkg-query -f='\${Version}' -W tracebox-web"); ?></td>
							</tr>
						</table>
						
						<!--------- system info -------------------->
						<table class="dev left">
							<tr>
								<td class="header" colspan="2">System</td>
							</tr>
							<tr>
								<td>Kernel version</td>
								<td><pre style="text-align:left; padding-left:1em;"><?php echo shell_exec("uname -a"); ?></pre></td>
							</tr>
							<tr>
								<td>Uptime</td>
								<td><pre style="text-align:left; padding-left:1em;"><?php echo shell_exec("uptime -p"); ?></pre></td>
							</tr>
							<tr>
								<td>Memory usage</td>
								<td><pre style="text-align:left; padding-left:1em;"><?php echo shell_exec("free -h --si"); ?></pre></td>
							</tr>
							<tr>
								<td>Disk usage</td>
								<td>
									<pre style="text-align:left; padding-left:1em;"><?php echo shell_exec("df -h"); ?></pre>
								</td>
							</tr>
						</table>
					</div>
				</section>
				
				<section id= 'help'>
					<h1>Help</h1>
					<div>   
						<h2>Documentation:</h2>
						<p>
							<a href="/manual.pdf" target="_blank">Manual</a>
						</p>
						<br>
						<h2>API:</h2>
						<p>
							<a href="/api.php" target="_blank">API commands</a>
						</p>
						<br>
						<h2>Contact:</h2>
						<p>
							<a href="mailto:Robert.Nedved@digiteqautomotive.com?subject=tracebox"><img height="30px">Robert.Nedved@DigiteqAutomotive.com</a>
							<br><br><br><br><br><br>
							<a><img src="img/digiteq_automotive.svg" height="75px"></a>
						</p>
	
					</div>
				</section>
			</div> 
		<!--/form-->
	</body>
	
</html> 

<?php
	//run autorefresh script when running on previous page
	print("
    <script>
        autoRefresh();
    </script>");

?>

