<?php
$apiUrl="http://{$_SERVER['SERVER_ADDR']}:8080/";
$devices=["ethernet", "can", "serial", "http"];

$ethernetAction=["device_list", "start", "stop", "set_name", "is_active"];
$canAction=["device_list", "start", "stop", "set_name", "set_speed", "is_active"];

?>

<!DOCTYPE html>
<html>
	<head>
		<link rel="stylesheet" media="screen" href="main.css">
	</head>
	<body>
	
		<section id= 'system_info'>
			<h1>API commands</h1>
			<div>
				<table class="dev left">
					<tr>
						<td class="header" colspan="2">System</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>info</td>
						<td class="left">Gives information about the daemon version.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>shutdown</td>
						<td class="left">Shuts down the tracebox.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>reboot</td>
						<td class="left">Reboots the tracebox.</td>
					</tr>
					<tr>
						<td class="header" colspan="2">Platform</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/list</td>
						<td class="left">Lists names of the already existing platforms.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/save/{platform_name}</td>
						<td class="left">Saves configuration of the chosen platform.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/load/{platform_name}</td>
						<td class="left">Loads configuration of the chosen platform.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/remove/{platform_name}</td>
						<td class="left">Removes configuration of the chosen platform.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/start</td>
						<td class="left">Starts tracing with the loaded platform configuration.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/stop</td>
						<td class="left">Stops tracing with the loaded platform configuration.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/is_active</td>
						<td class="left">Tells if the tracebox is tracing or not.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>platform/prepare_download</td>
						<td class="left">Downloads all traces available in the ZIP file.</td>
					</tr>
					<tr>
						<td class="header" colspan="2">Trigger</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/device_list</td>
						<td class="left">Lists names of all available trigger devices.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/{trigger_name}/trigger</td>
						<td class="left">Marks trigger on the chosen trigger device.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/{trigger_name}/info</td>
						<td class="left">Information about the chosen trigger.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/{trigger_name}/enable</td>
						<td class="left">Enables the chosen trigger.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/{trigger_name}/disable</td>
						<td class="left">Disables the chosen trigger.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>trigger/{trigger_name}/set_name/test</td>
						<td class="left">Sets name of the chosen trigger to test.</td>
					</tr>
					<tr>
						<td class="header" colspan="2">Commands for CAN, ETHERNET, HTTP and SERIAL</td>
					</tr>
					<tr>
						<td colspan="2">Possible values for type: can, ethernet, http, serial.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/device_list</td>
						<td class="left">Lists all available devices of the chosen device type.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/format_list</td>
						<td class="left">Lists all available trace formats of the chosen device type.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/start</td>
						<td class="left">Starts tracing of the chosen device. (If all required parameters are set.)</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/stop</td>
						<td class="left">Stops tracing of the chosen device.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/change_logfile</td>
						<td class="left">Creates new log file for the chosen device. (Old one is saved and closed.)</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/info</td>
						<td class="left">Informations about the chosen device.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/status</td>
						<td class="left">Status of the chosen device.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/enable</td>
						<td class="left">Enables the chosen device.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/disable</td>
						<td class="left">Disables the chosen device.</td>
					</tr>
					<tr>
						<td class="header" colspan="2">Additional Command for CAN and SERIAL</td>
					</tr>
					<tr>
						<td colspan="2">Possible values for type: can, serial.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>{type}/{device_name}/set_speed/{speed}</td>
						<td class="left">Speed for CAN: [bit/s]. Speed for Serial: [baud/s].</td>
					</tr>
					<tr>
						<td class="header" colspan="2">Additional Commands for HTTP</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>http/{device_name}/set_address/{ipv4_address}</td>
						<td class="left">Sets chosen device address to the desired value.</td>
					</tr>
					<tr>
						<td class="left"><?php echo ${apiUrl}?>http/{device_name}/set_port/{port}</td>
						<td class="left">Sets chosen device port to the desired value.</td>
					</tr>
				</table>
			</div>
		</section>	
		
		<form method="POST">
			<input type="button" onclick="window.location='<?php 
				if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') {
					$protocol = 'https';
				} else {
					$protocol = 'http';
				}
				$mainpage = $protocol . "://" . $_SERVER['HTTP_HOST'];
				echo $mainpage;
			?>'" name="mainPage" class="buttonMainPage" value="Main Page" />
		</form>
		
	</body>
</html>
